/*********************************************************************
*
* teach umenu.c -- Version 3.0 
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements 
* menus in the Teach program.
*
*********************************************************************/

#include <types.h>
#include <control.h>
#include <desk.h>
#include <font.h>
#include <intmath.h>
#include <memory.h>
#include <menu.h>
#include <textedit.h>
#include <window.h>
#include "teach.h"

extern unsigned int     quitFlag, userID;
extern WmTaskRec        event;



/*********************************************************************
* doQuitItem
*
* Just set the quitFlag -- that will do it.
*
*********************************************************************/
void    doQuitItem()
{
    quitFlag++;
}



/*********************************************************************
* doAboutItem
*
* Display the vanity box.
*
*********************************************************************/
void    doAboutItem()
{
    AlertWindow(refIsResource * 2, NULL, 1L);
}



/*********************************************************************
* doSelectAll
*
* Tell TextEdit to select all the text for the front window.
*
*********************************************************************/
void    doSelectAll()
{
    CtlRecHndl  thisHndl;

    thisHndl = GetCtlHandleFromID(FrontWindow(), MainWindowID);
    TESetSelection(0L, 0xFFFFFFFFL, thisHndl);
}



/*********************************************************************
* doChooseFont
*
* Use ChooseFont to select a different font, and then have TextEdit
* change the selected text in the top window.
*
*********************************************************************/
void    doChooseFont()
{
    Handle      tempHndl;
    CtlRecHndl  thisHndl;
    TEStyle     thisStyle;

    tempHndl = (Handle)NewHandle(20L, userID, 0, NULL);
        /* Create a Temporary handle for GetSelection Style. */

    thisHndl = GetCtlHandleFromID(FrontWindow(), MainWindowID);
        /* Get the handle to the TE control for the top window. */
    
    TEGetSelectionStyle(&thisStyle, tempHndl, thisHndl);
        /* Get the current font of the selection. */

    thisStyle.styleFontID.fidLong = ChooseFont(thisStyle.styleFontID.fidLong, 0);
        /* Use it as the default for ChooseFont. */

    TEStyleChange(teReplaceFont+teReplaceSize+teReplaceAttributes,
        &thisStyle, thisHndl);          /* Set font to user's choice. */

    DisposeHandle(tempHndl);            /* Get rid of the handle. */
}



/*********************************************************************
* doSetFont
*
* Change the family number for the selected text for the top window.
*
*********************************************************************/
void            doSetFont(theFam)
unsigned int    theFam;
{
    CtlRecHndl  thisHndl;
    TEStyle     thisStyle;

    thisHndl = GetCtlHandleFromID(FrontWindow(), MainWindowID);
        /* Get the handle to the TE control for the top window. */

    thisStyle.styleFontID.fidRec.famNum = theFam;

    TEStyleChange(teReplaceFont, &thisStyle, thisHndl);
        /* Set font to user's choice. */
}



/*********************************************************************
* doSetSize
*
* Change the font size for the selected text for the top window.
*
*********************************************************************/
void            doSetSize(theSize)
unsigned int    theSize;
{
    CtlRecHndl  thisHndl;
    TEStyle     thisStyle;

    thisHndl = GetCtlHandleFromID(FrontWindow(), MainWindowID);
        /* Get the handle to the TE control for the top window. */

    thisStyle.styleFontID.fidRec.fontSize = theSize;

    TEStyleChange(teReplaceSize, &thisStyle, thisHndl);
}



/*********************************************************************
* doSetStyle
*
*********************************************************************/
void            doSetStyle(theStyle)
unsigned int    theStyle;
{
    CtlRecHndl  thisHndl;
    TEStyle     thisStyle;

    thisHndl = GetCtlHandleFromID(FrontWindow(), MainWindowID);
        /* Get the handle to the TE control for the top window. */

    thisStyle.styleFontID.fidRec.fontStyle = theStyle;
        
    if (!theStyle) {
        TEStyleChange(teReplaceAttributes, &thisStyle, thisHndl);
    }
    else {
        TEStyleChange(teSwitchAttributes, &thisStyle, thisHndl);
    }
}



/*********************************************************************
* doMenu
*
* Function to handle all menu selections.  Examines the Event.TaskData
* menu item ID word from TaskMaster (from Event Manager) and calls the
* appropriate routine.  While the routine is running the menu title is
* still highlighted.  After the routine returns, we unhilight the
* menu title.
*
*********************************************************************/
void    doMenu()
{
    unsigned int    menuNum, itemNum;

    menuNum = HiWord (event.wmTaskData);
    itemNum = LoWord (event.wmTaskData);
    
    switch(itemNum) {
        case AboutItem:
            doAboutItem();
            break;
        case CloseItem:
            doCloseTop();
            break;
        case QuitItem:
            doQuitItem();
            break;
        case UndoItem:              /* Handled by taskmaster */
        case CutItem:               /* Handled by taskmaster */
        case CopyItem:              /* Handled by taskmaster */
        case PasteItem:             /* Handled by taskmaster */
        case ClearItem:             /* Handled by taskmaster */
            break;
        case SelectAllItem:
            doSelectAll();
            break;
        case NewItem:
            doNewWindow();
            break;
        case OpenItem:
            doOpenWindow();
            break;
        case SaveItem:
            doSave();
            break;
        case SaveAsItem:
            doSaveAs();
            break;
        case PageSetupItem:
            break;                  /* Not implemented yet. */
        case PrintItem:
            break;                  /* Not implemented yet. */
        case PlainItem:
            doSetStyle(0);
            break;
        case BoldItem:
            doSetStyle(boldMask);
            break;
        case ItalicItem:
            doSetStyle(italicMask);
            break;
        case UnderlineItem:
            doSetStyle(underlineMask);
            break;
        case ShadowItem:
            doSetStyle(shadowMask);
            break;
        case OutlineItem:
            doSetStyle(outlineMask);
            break;
        case Size8Item:
            doSetSize(8);
            break;
        case Size10Item:
            doSetSize(10);
            break;
        case Size12Item:
            doSetSize(12);
            break;
        case Size16Item:
            doSetSize(16);
            break;
        case Size20Item:
            doSetSize(20);
            break;
        case Size24Item:
            doSetSize(24);
            break;
        case ChooseFontItem:
            doChooseFont();
            break;
        default:
            if (itemNum >= FirstFontItem) doSetFont(ItemID2FamNum(itemNum));
            break;
    }

    HiliteMenu(0, menuNum);     /* Unhighlight the menu title. */
}



/*********************************************************************
* setupMenus
*
* Function to install our menu titles and their items in the system menu
* bar and to redraw it so we can see them.
*
*********************************************************************/
void    setupMenus()
{
    SetSysBar(NewMenuBar2(refIsResource, 0x0001L, NULL));
    SetMenuBar(NULL);
    
    FixAppleMenu(AppleMenuID);              /* Add DAs to apple menu. */

    FixFontMenu(FontMenuID, FirstFontItem, 0);

    FixMenuBar();                           /* Set sizes of menus. */
    
    /* Rather than drawing menu bar here, I rely on FixFrontW to do it first
    time through event loop. */
}
